# IP-406 - Update the web preview for invoices and quotes
UPDATE pd_settings
SET setting_value = 'InvoicePlane_Web'
WHERE setting_key = 'public_invoice_template' AND
      setting_value = 'default';

UPDATE pd_settings
SET setting_value = 'InvoicePlane_Web'
WHERE setting_key = 'public_quote_template' AND
      setting_value = 'default';

# IP-255 - Do not generate invoice number for draft invoices, set default value
INSERT INTO pd_settings (setting_key, setting_value)
VALUES ('generate_invoice_number_for_draft', '1');

INSERT INTO pd_settings (setting_key, setting_value)
VALUES ('generate_quote_number_for_draft', '1');

ALTER TABLE `pd_invoices`
  MODIFY COLUMN invoice_number VARCHAR(100) NULL DEFAULT NULL;

ALTER TABLE `pd_quotes`
  MODIFY COLUMN quote_number VARCHAR(100) NULL DEFAULT NULL;

# IP-408 - Add reference to products to items
ALTER TABLE `pd_invoice_items`
  ADD COLUMN IF NOT EXISTS  `item_product_id` INT(11) DEFAULT NULL
  AFTER `item_tax_rate_id`;

ALTER TABLE `pd_quote_items`
  ADD COLUMN IF NOT EXISTS  `item_product_id` INT(11) DEFAULT NULL
  AFTER `item_tax_rate_id`;

# IP-303 - Incorrect decimal value: '' for column 'item_discount_amount'
ALTER TABLE `pd_invoices`
  MODIFY COLUMN invoice_discount_amount DECIMAL(20, 2) NULL DEFAULT NULL,
  MODIFY COLUMN invoice_discount_percent DECIMAL(20, 2) NULL DEFAULT NULL;

ALTER TABLE `pd_invoice_item_amounts`
  MODIFY COLUMN item_discount DECIMAL(20, 2) NULL DEFAULT NULL;
ALTER TABLE `pd_invoice_items`
  MODIFY COLUMN item_discount_amount DECIMAL(20, 2) NULL DEFAULT NULL;

ALTER TABLE `pd_invoice_tax_rates`
  MODIFY COLUMN invoice_tax_rate_amount DECIMAL(10, 2) NOT NULL DEFAULT 0.00;

ALTER TABLE `pd_quotes`
  MODIFY COLUMN quote_discount_amount DECIMAL(20, 2) NULL DEFAULT NULL,
  MODIFY COLUMN quote_discount_percent DECIMAL(20, 2) NULL DEFAULT NULL;

ALTER TABLE `pd_quote_item_amounts`
  MODIFY COLUMN item_discount DECIMAL(20, 2) NULL DEFAULT NULL;
ALTER TABLE `pd_quote_items`
  MODIFY COLUMN item_discount_amount DECIMAL(20, 2) NULL DEFAULT NULL;

ALTER TABLE `pd_products`
  MODIFY COLUMN purchase_price DECIMAL(20, 2) NULL DEFAULT NULL;
ALTER TABLE `pd_products`
  MODIFY COLUMN product_price DECIMAL(20, 2) NULL DEFAULT NULL;

# IP-322 - Invoice item_name database field should be larger + additional db changes
ALTER TABLE pd_clients
  MODIFY COLUMN client_name TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_address_1 TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_address_2 TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_city TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_state TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_zip TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_country TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_phone TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_fax TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_mobile TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_email TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_web TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_vat_id TEXT;
ALTER TABLE pd_clients
  MODIFY COLUMN client_tax_code TEXT;
ALTER TABLE pd_custom_fields
  MODIFY COLUMN custom_field_table VARCHAR(255);
ALTER TABLE pd_custom_fields
  MODIFY COLUMN custom_field_label TEXT;
ALTER TABLE pd_custom_fields
  MODIFY COLUMN custom_field_column TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_title TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_subject TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_from_name TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_from_email TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_cc TEXT;
ALTER TABLE pd_email_templates
  MODIFY COLUMN email_template_bcc TEXT;
ALTER TABLE pd_families
  MODIFY COLUMN family_name TEXT;
ALTER TABLE pd_invoice_groups
  MODIFY COLUMN invoice_group_name TEXT;
ALTER TABLE pd_invoice_items
  MODIFY COLUMN item_name TEXT DEFAULT NULL;
ALTER TABLE pd_invoice_items
  MODIFY COLUMN item_description LONGTEXT DEFAULT NULL;
ALTER TABLE pd_invoice_items
  MODIFY COLUMN item_price DECIMAL(20, 2) DEFAULT NULL;
ALTER TABLE pd_payment_methods
  MODIFY COLUMN payment_method_name TEXT;
ALTER TABLE pd_payments
  MODIFY COLUMN payment_amount DECIMAL(20, 2);
ALTER TABLE pd_products
  MODIFY COLUMN product_sku TEXT;
ALTER TABLE pd_products
  MODIFY COLUMN product_name TEXT;
ALTER TABLE pd_projects
  MODIFY COLUMN project_name TEXT;
ALTER TABLE pd_quote_items
  MODIFY COLUMN item_name TEXT DEFAULT NULL;
ALTER TABLE pd_quote_items
  MODIFY COLUMN item_description TEXT DEFAULT NULL;
ALTER TABLE pd_quote_items
  MODIFY COLUMN item_quantity DECIMAL(20, 2) DEFAULT NULL;
ALTER TABLE pd_quote_items
  MODIFY COLUMN item_price DECIMAL(20, 2);
ALTER TABLE pd_quote_tax_rates
  MODIFY COLUMN quote_tax_rate_amount DECIMAL(20, 2);
ALTER TABLE pd_tasks
  MODIFY COLUMN task_name TEXT;
ALTER TABLE pd_tasks
  MODIFY COLUMN task_price DECIMAL(20, 2);
ALTER TABLE pd_tax_rates
  MODIFY COLUMN tax_rate_name TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_name TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_company TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_address_1 TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_address_2 TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_city TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_state TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_zip TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_country TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_phone TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_fax TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_mobile TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_email TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_web TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_vat_id TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_tax_code TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_psalt TEXT;
ALTER TABLE pd_users
  MODIFY COLUMN user_tax_code TEXT;

# IP-417 - Improve product database handling
ALTER TABLE pd_products
  MODIFY COLUMN family_id INT(11) NULL DEFAULT NULL;
ALTER TABLE pd_products
  MODIFY COLUMN tax_rate_id INT(11) NULL DEFAULT NULL;
ALTER TABLE pd_products
  ADD COLUMN IF NOT EXISTS provider_name TEXT NULL DEFAULT NULL
  AFTER purchase_price;

# Change values for read-only setting
UPDATE pd_settings
SET setting_value = 2
WHERE setting_key = 'read_only_toggle' AND
      setting_value = 'sent';

UPDATE pd_settings
SET setting_value = 3
WHERE setting_key = 'read_only_toggle' AND
      setting_value = 'viewed';

UPDATE pd_settings
SET setting_value = 4
WHERE setting_key = 'read_only_toggle' AND
      setting_value = 'paid';

# IP-422 - Improve session security
CREATE TABLE IF NOT EXISTS `pd_sessions` (
  session_id    VARCHAR(40) DEFAULT '0'    NOT NULL,
  ip_address    VARCHAR(45) DEFAULT '0'    NOT NULL,
  user_agent    VARCHAR(120)               NOT NULL,
  last_activity INT(10) UNSIGNED DEFAULT 0 NOT NULL,
  user_data     TEXT                       NOT NULL,
  PRIMARY KEY (session_id),
  KEY `last_activity_idx` (`last_activity`)
);
